package zio.aws.elasticloadbalancingv2.model
import zio.aws.elasticloadbalancingv2.model.primitives.{
  VpcId,
  LoadBalancerArn,
  DNSName,
  EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic,
  SecurityGroupId,
  LoadBalancerName,
  CustomerOwnedIpv4Pool,
  CanonicalHostedZoneId,
  CreatedTime
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class LoadBalancer(
    loadBalancerArn: Optional[LoadBalancerArn] = Optional.Absent,
    dnsName: Optional[DNSName] = Optional.Absent,
    canonicalHostedZoneId: Optional[CanonicalHostedZoneId] = Optional.Absent,
    createdTime: Optional[CreatedTime] = Optional.Absent,
    loadBalancerName: Optional[LoadBalancerName] = Optional.Absent,
    scheme: Optional[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum
    ] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent,
    state: Optional[zio.aws.elasticloadbalancingv2.model.LoadBalancerState] =
      Optional.Absent,
    `type`: Optional[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum
    ] = Optional.Absent,
    availabilityZones: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.AvailabilityZone]
    ] = Optional.Absent,
    securityGroups: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    ipAddressType: Optional[
      zio.aws.elasticloadbalancingv2.model.IpAddressType
    ] = Optional.Absent,
    customerOwnedIpv4Pool: Optional[CustomerOwnedIpv4Pool] = Optional.Absent,
    enforceSecurityGroupInboundRulesOnPrivateLinkTraffic: Optional[
      EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer = {
    import LoadBalancer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer
      .builder()
      .optionallyWith(
        loadBalancerArn.map(value =>
          LoadBalancerArn.unwrap(value): java.lang.String
        )
      )(_.loadBalancerArn)
      .optionallyWith(
        dnsName.map(value => DNSName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        canonicalHostedZoneId.map(value =>
          CanonicalHostedZoneId.unwrap(value): java.lang.String
        )
      )(_.canonicalHostedZoneId)
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        loadBalancerName.map(value =>
          LoadBalancerName.unwrap(value): java.lang.String
        )
      )(_.loadBalancerName)
      .optionallyWith(scheme.map(value => value.unwrap))(_.scheme)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(
        customerOwnedIpv4Pool.map(value =>
          CustomerOwnedIpv4Pool.unwrap(value): java.lang.String
        )
      )(_.customerOwnedIpv4Pool)
      .optionallyWith(
        enforceSecurityGroupInboundRulesOnPrivateLinkTraffic.map(value =>
          EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic.unwrap(
            value
          ): java.lang.String
        )
      )(_.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.LoadBalancer.wrap(buildAwsValue())
}
object LoadBalancer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.LoadBalancer =
      zio.aws.elasticloadbalancingv2.model.LoadBalancer(
        loadBalancerArn.map(value => value),
        dnsName.map(value => value),
        canonicalHostedZoneId.map(value => value),
        createdTime.map(value => value),
        loadBalancerName.map(value => value),
        scheme.map(value => value),
        vpcId.map(value => value),
        state.map(value => value.asEditable),
        `type`.map(value => value),
        availabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityGroups.map(value => value),
        ipAddressType.map(value => value),
        customerOwnedIpv4Pool.map(value => value),
        enforceSecurityGroupInboundRulesOnPrivateLinkTraffic.map(value => value)
      )
    def loadBalancerArn: Optional[LoadBalancerArn]
    def dnsName: Optional[DNSName]
    def canonicalHostedZoneId: Optional[CanonicalHostedZoneId]
    def createdTime: Optional[CreatedTime]
    def loadBalancerName: Optional[LoadBalancerName]
    def scheme
        : Optional[zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum]
    def vpcId: Optional[VpcId]
    def state: Optional[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerState.ReadOnly
    ]
    def `type`
        : Optional[zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum]
    def availabilityZones: Optional[
      List[zio.aws.elasticloadbalancingv2.model.AvailabilityZone.ReadOnly]
    ]
    def securityGroups: Optional[List[SecurityGroupId]]
    def ipAddressType
        : Optional[zio.aws.elasticloadbalancingv2.model.IpAddressType]
    def customerOwnedIpv4Pool: Optional[CustomerOwnedIpv4Pool]
    def enforceSecurityGroupInboundRulesOnPrivateLinkTraffic
        : Optional[EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic]
    def getLoadBalancerArn: ZIO[Any, AwsError, LoadBalancerArn] =
      AwsError.unwrapOptionField("loadBalancerArn", loadBalancerArn)
    def getDnsName: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getCanonicalHostedZoneId: ZIO[Any, AwsError, CanonicalHostedZoneId] =
      AwsError.unwrapOptionField("canonicalHostedZoneId", canonicalHostedZoneId)
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLoadBalancerName: ZIO[Any, AwsError, LoadBalancerName] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerName)
    def getScheme: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum
    ] = AwsError.unwrapOptionField("scheme", scheme)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.LoadBalancerState.ReadOnly
    ] = AwsError.unwrapOptionField("state", state)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum
    ] = AwsError.unwrapOptionField("type", `type`)
    def getAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.AvailabilityZone.ReadOnly
    ]] = AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getIpAddressType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.IpAddressType
    ] = AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getCustomerOwnedIpv4Pool: ZIO[Any, AwsError, CustomerOwnedIpv4Pool] =
      AwsError.unwrapOptionField("customerOwnedIpv4Pool", customerOwnedIpv4Pool)
    def getEnforceSecurityGroupInboundRulesOnPrivateLinkTraffic: ZIO[
      Any,
      AwsError,
      EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic
    ] = AwsError.unwrapOptionField(
      "enforceSecurityGroupInboundRulesOnPrivateLinkTraffic",
      enforceSecurityGroupInboundRulesOnPrivateLinkTraffic
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer
  ) extends zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly {
    override val loadBalancerArn: Optional[LoadBalancerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerArn())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerArn(value)
        )
    override val dnsName: Optional[DNSName] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.DNSName(value)
      )
    override val canonicalHostedZoneId: Optional[CanonicalHostedZoneId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canonicalHostedZoneId())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .CanonicalHostedZoneId(value)
        )
    override val createdTime: Optional[CreatedTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.CreatedTime(value)
      )
    override val loadBalancerName: Optional[LoadBalancerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerName())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .LoadBalancerName(value)
        )
    override val scheme: Optional[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scheme())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum.wrap(value)
      )
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.VpcId(value)
      )
    override val state: Optional[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerState.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.LoadBalancerState.wrap(value)
      )
    override val `type`
        : Optional[zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum.wrap(value)
        )
    override val availabilityZones: Optional[
      List[zio.aws.elasticloadbalancingv2.model.AvailabilityZone.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.AvailabilityZone.wrap(item)
        }.toList
      )
    override val securityGroups: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.primitives
              .SecurityGroupId(item)
          }.toList
        )
    override val ipAddressType
        : Optional[zio.aws.elasticloadbalancingv2.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.IpAddressType.wrap(value)
        )
    override val customerOwnedIpv4Pool: Optional[CustomerOwnedIpv4Pool] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerOwnedIpv4Pool())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .CustomerOwnedIpv4Pool(value)
        )
    override val enforceSecurityGroupInboundRulesOnPrivateLinkTraffic
        : Optional[EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic] =
      zio.aws.core.internal
        .optionalFromNullable(
          impl.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic()
        )
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer
  ): zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly = new Wrapper(
    impl
  )
}
