package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetIpAddressTypeResponse(
    ipAddressType: Optional[
      zio.aws.elasticloadbalancingv2.model.IpAddressType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeResponse = {
    import SetIpAddressTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeResponse
      .builder()
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.SetIpAddressTypeResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.SetIpAddressTypeResponse
      .wrap(buildAwsValue())
}
object SetIpAddressTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.SetIpAddressTypeResponse =
      zio.aws.elasticloadbalancingv2.model
        .SetIpAddressTypeResponse(ipAddressType.map(value => value))
    def ipAddressType
        : Optional[zio.aws.elasticloadbalancingv2.model.IpAddressType]
    def getIpAddressType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.IpAddressType
    ] = AwsError.unwrapOptionField("ipAddressType", ipAddressType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeResponse
  ) extends zio.aws.elasticloadbalancingv2.model.SetIpAddressTypeResponse.ReadOnly {
    override val ipAddressType
        : Optional[zio.aws.elasticloadbalancingv2.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.IpAddressType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeResponse
  ): zio.aws.elasticloadbalancingv2.model.SetIpAddressTypeResponse.ReadOnly =
    new Wrapper(impl)
}
