package zio.aws.elasticloadbalancingv2.model
import scala.jdk.CollectionConverters._
sealed trait ProtocolEnum {
  def unwrap: software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum
}
object ProtocolEnum {
  def wrap(
      value: software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum
  ): zio.aws.elasticloadbalancingv2.model.ProtocolEnum = value match {
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum.HTTP =>
      val r = HTTP
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum.HTTPS =>
      val r = HTTPS
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum.TCP =>
      val r = TCP
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum.TLS =>
      val r = TLS
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum.UDP =>
      val r = UDP
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum.TCP_UDP =>
      val r = TCP_UDP
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum.GENEVE =>
      val r = GENEVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticloadbalancingv2.model.ProtocolEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTP extends zio.aws.elasticloadbalancingv2.model.ProtocolEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum.HTTP
  }
  case object HTTPS extends zio.aws.elasticloadbalancingv2.model.ProtocolEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum.HTTPS
  }
  case object TCP extends zio.aws.elasticloadbalancingv2.model.ProtocolEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum.TCP
  }
  case object TLS extends zio.aws.elasticloadbalancingv2.model.ProtocolEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum.TLS
  }
  case object UDP extends zio.aws.elasticloadbalancingv2.model.ProtocolEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum.UDP
  }
  case object TCP_UDP
      extends zio.aws.elasticloadbalancingv2.model.ProtocolEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum.TCP_UDP
  }
  case object GENEVE extends zio.aws.elasticloadbalancingv2.model.ProtocolEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum.GENEVE
  }
}
