package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticloadbalancingv2.model.primitives.{
  AuthenticateOidcActionAuthenticationRequestParamValue,
  AuthenticateOidcActionScope,
  AuthenticateOidcActionClientSecret,
  AuthenticateOidcActionUserInfoEndpoint,
  AuthenticateOidcActionAuthenticationRequestParamName,
  AuthenticateOidcActionClientId,
  AuthenticateOidcActionAuthorizationEndpoint,
  AuthenticateOidcActionSessionCookieName,
  AuthenticateOidcActionSessionTimeout,
  AuthenticateOidcActionIssuer,
  AuthenticateOidcActionUseExistingClientSecret,
  AuthenticateOidcActionTokenEndpoint
}
import scala.jdk.CollectionConverters._
final case class AuthenticateOidcActionConfig(
    issuer: AuthenticateOidcActionIssuer,
    authorizationEndpoint: AuthenticateOidcActionAuthorizationEndpoint,
    tokenEndpoint: AuthenticateOidcActionTokenEndpoint,
    userInfoEndpoint: AuthenticateOidcActionUserInfoEndpoint,
    clientId: AuthenticateOidcActionClientId,
    clientSecret: Optional[AuthenticateOidcActionClientSecret] =
      Optional.Absent,
    sessionCookieName: Optional[AuthenticateOidcActionSessionCookieName] =
      Optional.Absent,
    scope: Optional[AuthenticateOidcActionScope] = Optional.Absent,
    sessionTimeout: Optional[AuthenticateOidcActionSessionTimeout] =
      Optional.Absent,
    authenticationRequestExtraParams: Optional[Map[
      AuthenticateOidcActionAuthenticationRequestParamName,
      AuthenticateOidcActionAuthenticationRequestParamValue
    ]] = Optional.Absent,
    onUnauthenticatedRequest: Optional[
      zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConditionalBehaviorEnum
    ] = Optional.Absent,
    useExistingClientSecret: Optional[
      AuthenticateOidcActionUseExistingClientSecret
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig = {
    import AuthenticateOidcActionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig
      .builder()
      .issuer(AuthenticateOidcActionIssuer.unwrap(issuer): java.lang.String)
      .authorizationEndpoint(
        AuthenticateOidcActionAuthorizationEndpoint.unwrap(
          authorizationEndpoint
        ): java.lang.String
      )
      .tokenEndpoint(
        AuthenticateOidcActionTokenEndpoint.unwrap(
          tokenEndpoint
        ): java.lang.String
      )
      .userInfoEndpoint(
        AuthenticateOidcActionUserInfoEndpoint.unwrap(
          userInfoEndpoint
        ): java.lang.String
      )
      .clientId(
        AuthenticateOidcActionClientId.unwrap(clientId): java.lang.String
      )
      .optionallyWith(
        clientSecret.map(value =>
          AuthenticateOidcActionClientSecret.unwrap(value): java.lang.String
        )
      )(_.clientSecret)
      .optionallyWith(
        sessionCookieName.map(value =>
          AuthenticateOidcActionSessionCookieName.unwrap(
            value
          ): java.lang.String
        )
      )(_.sessionCookieName)
      .optionallyWith(
        scope.map(value =>
          AuthenticateOidcActionScope.unwrap(value): java.lang.String
        )
      )(_.scope)
      .optionallyWith(
        sessionTimeout.map(value =>
          AuthenticateOidcActionSessionTimeout.unwrap(value): java.lang.Long
        )
      )(_.sessionTimeout)
      .optionallyWith(
        authenticationRequestExtraParams.map(value =>
          value
            .map({ case (key, value) =>
              (AuthenticateOidcActionAuthenticationRequestParamName.unwrap(
                key
              ): java.lang.String) -> (AuthenticateOidcActionAuthenticationRequestParamValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.authenticationRequestExtraParams)
      .optionallyWith(onUnauthenticatedRequest.map(value => value.unwrap))(
        _.onUnauthenticatedRequest
      )
      .optionallyWith(
        useExistingClientSecret.map(value =>
          AuthenticateOidcActionUseExistingClientSecret.unwrap(
            value
          ): java.lang.Boolean
        )
      )(_.useExistingClientSecret)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConfig.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConfig
      .wrap(buildAwsValue())
}
object AuthenticateOidcActionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConfig =
      zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConfig(
        issuer,
        authorizationEndpoint,
        tokenEndpoint,
        userInfoEndpoint,
        clientId,
        clientSecret.map(value => value),
        sessionCookieName.map(value => value),
        scope.map(value => value),
        sessionTimeout.map(value => value),
        authenticationRequestExtraParams.map(value => value),
        onUnauthenticatedRequest.map(value => value),
        useExistingClientSecret.map(value => value)
      )
    def issuer: AuthenticateOidcActionIssuer
    def authorizationEndpoint: AuthenticateOidcActionAuthorizationEndpoint
    def tokenEndpoint: AuthenticateOidcActionTokenEndpoint
    def userInfoEndpoint: AuthenticateOidcActionUserInfoEndpoint
    def clientId: AuthenticateOidcActionClientId
    def clientSecret: Optional[AuthenticateOidcActionClientSecret]
    def sessionCookieName: Optional[AuthenticateOidcActionSessionCookieName]
    def scope: Optional[AuthenticateOidcActionScope]
    def sessionTimeout: Optional[AuthenticateOidcActionSessionTimeout]
    def authenticationRequestExtraParams: Optional[Map[
      AuthenticateOidcActionAuthenticationRequestParamName,
      AuthenticateOidcActionAuthenticationRequestParamValue
    ]]
    def onUnauthenticatedRequest: Optional[
      zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConditionalBehaviorEnum
    ]
    def useExistingClientSecret
        : Optional[AuthenticateOidcActionUseExistingClientSecret]
    def getIssuer: ZIO[Any, Nothing, AuthenticateOidcActionIssuer] =
      ZIO.succeed(issuer)
    def getAuthorizationEndpoint
        : ZIO[Any, Nothing, AuthenticateOidcActionAuthorizationEndpoint] =
      ZIO.succeed(authorizationEndpoint)
    def getTokenEndpoint
        : ZIO[Any, Nothing, AuthenticateOidcActionTokenEndpoint] =
      ZIO.succeed(tokenEndpoint)
    def getUserInfoEndpoint
        : ZIO[Any, Nothing, AuthenticateOidcActionUserInfoEndpoint] =
      ZIO.succeed(userInfoEndpoint)
    def getClientId: ZIO[Any, Nothing, AuthenticateOidcActionClientId] =
      ZIO.succeed(clientId)
    def getClientSecret
        : ZIO[Any, AwsError, AuthenticateOidcActionClientSecret] =
      AwsError.unwrapOptionField("clientSecret", clientSecret)
    def getSessionCookieName
        : ZIO[Any, AwsError, AuthenticateOidcActionSessionCookieName] =
      AwsError.unwrapOptionField("sessionCookieName", sessionCookieName)
    def getScope: ZIO[Any, AwsError, AuthenticateOidcActionScope] =
      AwsError.unwrapOptionField("scope", scope)
    def getSessionTimeout
        : ZIO[Any, AwsError, AuthenticateOidcActionSessionTimeout] =
      AwsError.unwrapOptionField("sessionTimeout", sessionTimeout)
    def getAuthenticationRequestExtraParams: ZIO[Any, AwsError, Map[
      AuthenticateOidcActionAuthenticationRequestParamName,
      AuthenticateOidcActionAuthenticationRequestParamValue
    ]] = AwsError.unwrapOptionField(
      "authenticationRequestExtraParams",
      authenticationRequestExtraParams
    )
    def getOnUnauthenticatedRequest: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConditionalBehaviorEnum
    ] = AwsError.unwrapOptionField(
      "onUnauthenticatedRequest",
      onUnauthenticatedRequest
    )
    def getUseExistingClientSecret
        : ZIO[Any, AwsError, AuthenticateOidcActionUseExistingClientSecret] =
      AwsError.unwrapOptionField(
        "useExistingClientSecret",
        useExistingClientSecret
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig
  ) extends zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConfig.ReadOnly {
    override val issuer: AuthenticateOidcActionIssuer =
      zio.aws.elasticloadbalancingv2.model.primitives
        .AuthenticateOidcActionIssuer(impl.issuer())
    override val authorizationEndpoint
        : AuthenticateOidcActionAuthorizationEndpoint =
      zio.aws.elasticloadbalancingv2.model.primitives
        .AuthenticateOidcActionAuthorizationEndpoint(
          impl.authorizationEndpoint()
        )
    override val tokenEndpoint: AuthenticateOidcActionTokenEndpoint =
      zio.aws.elasticloadbalancingv2.model.primitives
        .AuthenticateOidcActionTokenEndpoint(impl.tokenEndpoint())
    override val userInfoEndpoint: AuthenticateOidcActionUserInfoEndpoint =
      zio.aws.elasticloadbalancingv2.model.primitives
        .AuthenticateOidcActionUserInfoEndpoint(impl.userInfoEndpoint())
    override val clientId: AuthenticateOidcActionClientId =
      zio.aws.elasticloadbalancingv2.model.primitives
        .AuthenticateOidcActionClientId(impl.clientId())
    override val clientSecret: Optional[AuthenticateOidcActionClientSecret] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientSecret())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .AuthenticateOidcActionClientSecret(value)
        )
    override val sessionCookieName
        : Optional[AuthenticateOidcActionSessionCookieName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionCookieName())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .AuthenticateOidcActionSessionCookieName(value)
        )
    override val scope: Optional[AuthenticateOidcActionScope] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .AuthenticateOidcActionScope(value)
        )
    override val sessionTimeout
        : Optional[AuthenticateOidcActionSessionTimeout] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionTimeout())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .AuthenticateOidcActionSessionTimeout(value)
      )
    override val authenticationRequestExtraParams: Optional[Map[
      AuthenticateOidcActionAuthenticationRequestParamName,
      AuthenticateOidcActionAuthenticationRequestParamValue
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.authenticationRequestExtraParams())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.elasticloadbalancingv2.model.primitives
              .AuthenticateOidcActionAuthenticationRequestParamName(
                key
              ) -> zio.aws.elasticloadbalancingv2.model.primitives
              .AuthenticateOidcActionAuthenticationRequestParamValue(value)
          })
          .toMap
      )
    override val onUnauthenticatedRequest: Optional[
      zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConditionalBehaviorEnum
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.onUnauthenticatedRequest())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConditionalBehaviorEnum
          .wrap(value)
      )
    override val useExistingClientSecret
        : Optional[AuthenticateOidcActionUseExistingClientSecret] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useExistingClientSecret())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .AuthenticateOidcActionUseExistingClientSecret(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig
  ): zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConfig.ReadOnly =
    new Wrapper(impl)
}
