package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticloadbalancingv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class AddTagsRequest(
    resourceArns: Iterable[ResourceArn],
    tags: Iterable[zio.aws.elasticloadbalancingv2.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest = {
    import AddTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest
      .builder()
      .resourceArns(resourceArns.map { item =>
        ResourceArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.AddTagsRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.AddTagsRequest.wrap(buildAwsValue())
}
object AddTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.AddTagsRequest =
      zio.aws.elasticloadbalancingv2.model.AddTagsRequest(
        resourceArns,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArns: List[ResourceArn]
    def tags: List[zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly]
    def getResourceArns: ZIO[Any, Nothing, List[ResourceArn]] =
      ZIO.succeed(resourceArns)
    def getTags: ZIO[Any, Nothing, List[
      zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly
    ]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest
  ) extends zio.aws.elasticloadbalancingv2.model.AddTagsRequest.ReadOnly {
    override val resourceArns: List[ResourceArn] = impl
      .resourceArns()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancingv2.model.primitives.ResourceArn(item)
      }
      .toList
    override val tags: List[zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly] =
      impl
        .tags()
        .asScala
        .map { item =>
          zio.aws.elasticloadbalancingv2.model.Tag.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest
  ): zio.aws.elasticloadbalancingv2.model.AddTagsRequest.ReadOnly = new Wrapper(
    impl
  )
}
