package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters._
final case class Tag(key: TagKey, value: Option[TagValue] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .optionallyWith(
        value.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.Tag =
      zio.aws.elasticloadbalancingv2.model.Tag(key, value.map(value => value))
    def key: TagKey
    def value: Option[TagValue]
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag
  ) extends zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.elasticloadbalancingv2.model.primitives.TagKey(impl.key())
    override val value: Option[TagValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.TagValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag
  ): zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly = new Wrapper(impl)
}
