package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{GrpcCode, HttpCode}
import scala.jdk.CollectionConverters._
final case class Matcher(
    httpCode: Option[HttpCode] = None,
    grpcCode: Option[GrpcCode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.Matcher = {
    import Matcher.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Matcher
      .builder()
      .optionallyWith(
        httpCode.map(value => HttpCode.unwrap(value): java.lang.String)
      )(_.httpCode)
      .optionallyWith(
        grpcCode.map(value => GrpcCode.unwrap(value): java.lang.String)
      )(_.grpcCode)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.Matcher.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.Matcher.wrap(buildAwsValue())
}
object Matcher {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Matcher
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.Matcher =
      zio.aws.elasticloadbalancingv2.model
        .Matcher(httpCode.map(value => value), grpcCode.map(value => value))
    def httpCode: Option[HttpCode]
    def grpcCode: Option[GrpcCode]
    def getHttpCode: ZIO[Any, AwsError, HttpCode] =
      AwsError.unwrapOptionField("httpCode", httpCode)
    def getGrpcCode: ZIO[Any, AwsError, GrpcCode] =
      AwsError.unwrapOptionField("grpcCode", grpcCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Matcher
  ) extends zio.aws.elasticloadbalancingv2.model.Matcher.ReadOnly {
    override val httpCode: Option[HttpCode] = scala
      .Option(impl.httpCode())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.HttpCode(value)
      )
    override val grpcCode: Option[GrpcCode] = scala
      .Option(impl.grpcCode())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.GrpcCode(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Matcher
  ): zio.aws.elasticloadbalancingv2.model.Matcher.ReadOnly = new Wrapper(impl)
}
