package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  FixedResponseActionContentType,
  FixedResponseActionStatusCode,
  FixedResponseActionMessage
}
import scala.jdk.CollectionConverters._
final case class FixedResponseActionConfig(
    messageBody: Option[FixedResponseActionMessage] = None,
    statusCode: FixedResponseActionStatusCode,
    contentType: Option[FixedResponseActionContentType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.FixedResponseActionConfig = {
    import FixedResponseActionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.FixedResponseActionConfig
      .builder()
      .optionallyWith(
        messageBody.map(value =>
          FixedResponseActionMessage.unwrap(value): java.lang.String
        )
      )(_.messageBody)
      .statusCode(
        FixedResponseActionStatusCode.unwrap(statusCode): java.lang.String
      )
      .optionallyWith(
        contentType.map(value =>
          FixedResponseActionContentType.unwrap(value): java.lang.String
        )
      )(_.contentType)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.FixedResponseActionConfig.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.FixedResponseActionConfig
      .wrap(buildAwsValue())
}
object FixedResponseActionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.FixedResponseActionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.FixedResponseActionConfig =
      zio.aws.elasticloadbalancingv2.model.FixedResponseActionConfig(
        messageBody.map(value => value),
        statusCode,
        contentType.map(value => value)
      )
    def messageBody: Option[FixedResponseActionMessage]
    def statusCode: FixedResponseActionStatusCode
    def contentType: Option[FixedResponseActionContentType]
    def getMessageBody: ZIO[Any, AwsError, FixedResponseActionMessage] =
      AwsError.unwrapOptionField("messageBody", messageBody)
    def getStatusCode: ZIO[Any, Nothing, FixedResponseActionStatusCode] =
      ZIO.succeed(statusCode)
    def getContentType: ZIO[Any, AwsError, FixedResponseActionContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.FixedResponseActionConfig
  ) extends zio.aws.elasticloadbalancingv2.model.FixedResponseActionConfig.ReadOnly {
    override val messageBody: Option[FixedResponseActionMessage] = scala
      .Option(impl.messageBody())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .FixedResponseActionMessage(value)
      )
    override val statusCode: FixedResponseActionStatusCode =
      zio.aws.elasticloadbalancingv2.model.primitives
        .FixedResponseActionStatusCode(impl.statusCode())
    override val contentType: Option[FixedResponseActionContentType] = scala
      .Option(impl.contentType())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .FixedResponseActionContentType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.FixedResponseActionConfig
  ): zio.aws.elasticloadbalancingv2.model.FixedResponseActionConfig.ReadOnly =
    new Wrapper(impl)
}
