package zio.aws.elasticloadbalancingv2.model
import scala.jdk.CollectionConverters._
sealed trait LoadBalancerSchemeEnum {
  def unwrap: software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum
}
object LoadBalancerSchemeEnum {
  def wrap(
      value: software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum
  ): zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum = value match {
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum.INTERNET_FACING =>
      val r = `internet-facing`
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum.INTERNAL =>
      val r = internal
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object `internet-facing`
      extends zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum.INTERNET_FACING
  }
  case object internal
      extends zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum.INTERNAL
  }
}
