package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticloadbalancingv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class DescribeTagsRequest(resourceArns: Iterable[ResourceArn]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest = {
    import DescribeTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest
      .builder()
      .resourceArns(resourceArns.map { item =>
        ResourceArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeTagsRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeTagsRequest
      .wrap(buildAwsValue())
}
object DescribeTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.DescribeTagsRequest =
      zio.aws.elasticloadbalancingv2.model.DescribeTagsRequest(resourceArns)
    def resourceArns: List[ResourceArn]
    def getResourceArns: ZIO[Any, Nothing, List[ResourceArn]] =
      ZIO.succeed(resourceArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeTagsRequest.ReadOnly {
    override val resourceArns: List[ResourceArn] = impl
      .resourceArns()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancingv2.model.primitives.ResourceArn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest
  ): zio.aws.elasticloadbalancingv2.model.DescribeTagsRequest.ReadOnly =
    new Wrapper(impl)
}
