package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticloadbalancingv2.model.primitives.ListenerArn
import scala.jdk.CollectionConverters._
final case class DeleteListenerRequest(listenerArn: ListenerArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest = {
    import DeleteListenerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest
      .builder()
      .listenerArn(ListenerArn.unwrap(listenerArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DeleteListenerRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DeleteListenerRequest
      .wrap(buildAwsValue())
}
object DeleteListenerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.DeleteListenerRequest =
      zio.aws.elasticloadbalancingv2.model.DeleteListenerRequest(listenerArn)
    def listenerArn: ListenerArn
    def getListenerArn: ZIO[Any, Nothing, ListenerArn] =
      ZIO.succeed(listenerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DeleteListenerRequest.ReadOnly {
    override val listenerArn: ListenerArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .ListenerArn(impl.listenerArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest
  ): zio.aws.elasticloadbalancingv2.model.DeleteListenerRequest.ReadOnly =
    new Wrapper(impl)
}
