package zio.aws.elasticloadbalancingv2.model
import zio.aws.elasticloadbalancingv2.model.primitives.{
  TargetGroupStickinessDurationSeconds,
  TargetGroupStickinessEnabled
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class TargetGroupStickinessConfig(
    enabled: Optional[TargetGroupStickinessEnabled] = Optional.Absent,
    durationSeconds: Optional[TargetGroupStickinessDurationSeconds] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupStickinessConfig = {
    import TargetGroupStickinessConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupStickinessConfig
      .builder()
      .optionallyWith(
        enabled.map(value =>
          TargetGroupStickinessEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.enabled)
      .optionallyWith(
        durationSeconds.map(value =>
          TargetGroupStickinessDurationSeconds.unwrap(value): Integer
        )
      )(_.durationSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig
      .wrap(buildAwsValue())
}
object TargetGroupStickinessConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupStickinessConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig =
      zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig(
        enabled.map(value => value),
        durationSeconds.map(value => value)
      )
    def enabled: Optional[TargetGroupStickinessEnabled]
    def durationSeconds: Optional[TargetGroupStickinessDurationSeconds]
    def getEnabled: ZIO[Any, AwsError, TargetGroupStickinessEnabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getDurationSeconds
        : ZIO[Any, AwsError, TargetGroupStickinessDurationSeconds] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupStickinessConfig
  ) extends zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig.ReadOnly {
    override val enabled: Optional[TargetGroupStickinessEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enabled())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .TargetGroupStickinessEnabled(value)
        )
    override val durationSeconds
        : Optional[TargetGroupStickinessDurationSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.durationSeconds())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .TargetGroupStickinessDurationSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupStickinessConfig
  ): zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig.ReadOnly =
    new Wrapper(impl)
}
