package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticloadbalancingv2.model.primitives.Marker
import scala.jdk.CollectionConverters._
final case class DescribeLoadBalancersResponse(
    loadBalancers: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.LoadBalancer]
    ] = Optional.Absent,
    nextMarker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse = {
    import DescribeLoadBalancersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse
      .builder()
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse
      .wrap(buildAwsValue())
}
object DescribeLoadBalancersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse =
      zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse(
        loadBalancers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def loadBalancers: Optional[
      List[zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly]
    ]
    def nextMarker: Optional[Marker]
    def getLoadBalancers: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly
    ]] = AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse.ReadOnly {
    override val loadBalancers: Optional[
      List[zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loadBalancers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.LoadBalancer.wrap(item)
        }.toList
      )
    override val nextMarker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse
  ): zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse.ReadOnly =
    new Wrapper(impl)
}
