package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupArn
import scala.jdk.CollectionConverters._
final case class DescribeTargetHealthRequest(
    targetGroupArn: TargetGroupArn,
    targets: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.TargetDescription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest = {
    import DescribeTargetHealthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest
      .builder()
      .targetGroupArn(TargetGroupArn.unwrap(targetGroupArn): java.lang.String)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthRequest
      .wrap(buildAwsValue())
}
object DescribeTargetHealthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthRequest =
      zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthRequest(
        targetGroupArn,
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def targetGroupArn: TargetGroupArn
    def targets: Optional[
      List[zio.aws.elasticloadbalancingv2.model.TargetDescription.ReadOnly]
    ]
    def getTargetGroupArn: ZIO[Any, Nothing, TargetGroupArn] =
      ZIO.succeed(targetGroupArn)
    def getTargets: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.TargetDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("targets", targets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthRequest.ReadOnly {
    override val targetGroupArn: TargetGroupArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .TargetGroupArn(impl.targetGroupArn())
    override val targets: Optional[
      List[zio.aws.elasticloadbalancingv2.model.TargetDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.TargetDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest
  ): zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthRequest.ReadOnly =
    new Wrapper(impl)
}
