package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticloadbalancingv2.model.primitives.Marker
import scala.jdk.CollectionConverters._
final case class DescribeTargetGroupsResponse(
    targetGroups: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.TargetGroup]
    ] = Optional.Absent,
    nextMarker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse = {
    import DescribeTargetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse
      .builder()
      .optionallyWith(
        targetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetGroups)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeTargetGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse =
      zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse(
        targetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def targetGroups: Optional[
      List[zio.aws.elasticloadbalancingv2.model.TargetGroup.ReadOnly]
    ]
    def nextMarker: Optional[Marker]
    def getTargetGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.TargetGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("targetGroups", targetGroups)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse.ReadOnly {
    override val targetGroups: Optional[
      List[zio.aws.elasticloadbalancingv2.model.TargetGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.TargetGroup.wrap(item)
        }.toList
      )
    override val nextMarker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse
  ): zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
