package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupArn
import scala.jdk.CollectionConverters._
final case class DeleteTargetGroupRequest(targetGroupArn: TargetGroupArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest = {
    import DeleteTargetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest
      .builder()
      .targetGroupArn(TargetGroupArn.unwrap(targetGroupArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DeleteTargetGroupRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DeleteTargetGroupRequest
      .wrap(buildAwsValue())
}
object DeleteTargetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DeleteTargetGroupRequest =
      zio.aws.elasticloadbalancingv2.model
        .DeleteTargetGroupRequest(targetGroupArn)
    def targetGroupArn: TargetGroupArn
    def getTargetGroupArn: ZIO[Any, Nothing, TargetGroupArn] =
      ZIO.succeed(targetGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DeleteTargetGroupRequest.ReadOnly {
    override val targetGroupArn: TargetGroupArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .TargetGroupArn(impl.targetGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest
  ): zio.aws.elasticloadbalancingv2.model.DeleteTargetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
