package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticloadbalancingv2.model.primitives.{
  StringValue,
  ConditionFieldName
}
import scala.jdk.CollectionConverters._
final case class RuleCondition(
    field: Optional[ConditionFieldName] = Optional.Absent,
    values: Optional[Iterable[StringValue]] = Optional.Absent,
    hostHeaderConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.HostHeaderConditionConfig
    ] = Optional.Absent,
    pathPatternConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.PathPatternConditionConfig
    ] = Optional.Absent,
    httpHeaderConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.HttpHeaderConditionConfig
    ] = Optional.Absent,
    queryStringConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.QueryStringConditionConfig
    ] = Optional.Absent,
    httpRequestMethodConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.HttpRequestMethodConditionConfig
    ] = Optional.Absent,
    sourceIpConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.SourceIpConditionConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition = {
    import RuleCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition
      .builder()
      .optionallyWith(
        field.map(value => ConditionFieldName.unwrap(value): java.lang.String)
      )(_.field)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            StringValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .optionallyWith(hostHeaderConfig.map(value => value.buildAwsValue()))(
        _.hostHeaderConfig
      )
      .optionallyWith(pathPatternConfig.map(value => value.buildAwsValue()))(
        _.pathPatternConfig
      )
      .optionallyWith(httpHeaderConfig.map(value => value.buildAwsValue()))(
        _.httpHeaderConfig
      )
      .optionallyWith(queryStringConfig.map(value => value.buildAwsValue()))(
        _.queryStringConfig
      )
      .optionallyWith(
        httpRequestMethodConfig.map(value => value.buildAwsValue())
      )(_.httpRequestMethodConfig)
      .optionallyWith(sourceIpConfig.map(value => value.buildAwsValue()))(
        _.sourceIpConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.RuleCondition.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.RuleCondition.wrap(buildAwsValue())
}
object RuleCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.RuleCondition =
      zio.aws.elasticloadbalancingv2.model.RuleCondition(
        field.map(value => value),
        values.map(value => value),
        hostHeaderConfig.map(value => value.asEditable),
        pathPatternConfig.map(value => value.asEditable),
        httpHeaderConfig.map(value => value.asEditable),
        queryStringConfig.map(value => value.asEditable),
        httpRequestMethodConfig.map(value => value.asEditable),
        sourceIpConfig.map(value => value.asEditable)
      )
    def field: Optional[ConditionFieldName]
    def values: Optional[List[StringValue]]
    def hostHeaderConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.HostHeaderConditionConfig.ReadOnly
    ]
    def pathPatternConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.PathPatternConditionConfig.ReadOnly
    ]
    def httpHeaderConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.HttpHeaderConditionConfig.ReadOnly
    ]
    def queryStringConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.QueryStringConditionConfig.ReadOnly
    ]
    def httpRequestMethodConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.HttpRequestMethodConditionConfig.ReadOnly
    ]
    def sourceIpConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.SourceIpConditionConfig.ReadOnly
    ]
    def getField: ZIO[Any, AwsError, ConditionFieldName] =
      AwsError.unwrapOptionField("field", field)
    def getValues: ZIO[Any, AwsError, List[StringValue]] =
      AwsError.unwrapOptionField("values", values)
    def getHostHeaderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.HostHeaderConditionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("hostHeaderConfig", hostHeaderConfig)
    def getPathPatternConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.PathPatternConditionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("pathPatternConfig", pathPatternConfig)
    def getHttpHeaderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.HttpHeaderConditionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("httpHeaderConfig", httpHeaderConfig)
    def getQueryStringConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.QueryStringConditionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("queryStringConfig", queryStringConfig)
    def getHttpRequestMethodConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.HttpRequestMethodConditionConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "httpRequestMethodConfig",
      httpRequestMethodConfig
    )
    def getSourceIpConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.SourceIpConditionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("sourceIpConfig", sourceIpConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition
  ) extends zio.aws.elasticloadbalancingv2.model.RuleCondition.ReadOnly {
    override val field: Optional[ConditionFieldName] = zio.aws.core.internal
      .optionalFromNullable(impl.field())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .ConditionFieldName(value)
      )
    override val values: Optional[List[StringValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.StringValue(item)
        }.toList
      )
    override val hostHeaderConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.HostHeaderConditionConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hostHeaderConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.HostHeaderConditionConfig
          .wrap(value)
      )
    override val pathPatternConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.PathPatternConditionConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pathPatternConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.PathPatternConditionConfig
          .wrap(value)
      )
    override val httpHeaderConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.HttpHeaderConditionConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.httpHeaderConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.HttpHeaderConditionConfig
          .wrap(value)
      )
    override val queryStringConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.QueryStringConditionConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.queryStringConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.QueryStringConditionConfig
          .wrap(value)
      )
    override val httpRequestMethodConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.HttpRequestMethodConditionConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.httpRequestMethodConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.HttpRequestMethodConditionConfig
          .wrap(value)
      )
    override val sourceIpConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.SourceIpConditionConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIpConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.SourceIpConditionConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition
  ): zio.aws.elasticloadbalancingv2.model.RuleCondition.ReadOnly = new Wrapper(
    impl
  )
}
