package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLoadBalancerResponse(
    loadBalancers: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.LoadBalancer]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse = {
    import CreateLoadBalancerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse
      .builder()
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerResponse
      .wrap(buildAwsValue())
}
object CreateLoadBalancerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerResponse =
      zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerResponse(
        loadBalancers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def loadBalancers: Optional[
      List[zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly]
    ]
    def getLoadBalancers: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly
    ]] = AwsError.unwrapOptionField("loadBalancers", loadBalancers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse
  ) extends zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerResponse.ReadOnly {
    override val loadBalancers: Optional[
      List[zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loadBalancers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.LoadBalancer.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse
  ): zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerResponse.ReadOnly =
    new Wrapper(impl)
}
