package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyLoadBalancerAttributesResponse(
    attributes: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse = {
    import ModifyLoadBalancerAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse
      .wrap(buildAwsValue())
}
object ModifyLoadBalancerAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse =
      zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse(
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attributes: Optional[
      List[zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute.ReadOnly]
    ]
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse
  ) extends zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse.ReadOnly {
    override val attributes: Optional[
      List[zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse
  ): zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
