package zio.aws.elasticloadbalancingv2.model
import zio.aws.elasticloadbalancingv2.model.primitives.{
  Marker,
  LoadBalancerArn,
  TargetGroupArn,
  PageSize,
  TargetGroupName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeTargetGroupsRequest(
    loadBalancerArn: Optional[LoadBalancerArn] = Optional.Absent,
    targetGroupArns: Optional[Iterable[TargetGroupArn]] = Optional.Absent,
    names: Optional[Iterable[TargetGroupName]] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent,
    pageSize: Optional[PageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest = {
    import DescribeTargetGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest
      .builder()
      .optionallyWith(
        loadBalancerArn.map(value =>
          LoadBalancerArn.unwrap(value): java.lang.String
        )
      )(_.loadBalancerArn)
      .optionallyWith(
        targetGroupArns.map(value =>
          value.map { item =>
            TargetGroupArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetGroupArns)
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            TargetGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsRequest
      .wrap(buildAwsValue())
}
object DescribeTargetGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsRequest =
      zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsRequest(
        loadBalancerArn.map(value => value),
        targetGroupArns.map(value => value),
        names.map(value => value),
        marker.map(value => value),
        pageSize.map(value => value)
      )
    def loadBalancerArn: Optional[LoadBalancerArn]
    def targetGroupArns: Optional[List[TargetGroupArn]]
    def names: Optional[List[TargetGroupName]]
    def marker: Optional[Marker]
    def pageSize: Optional[PageSize]
    def getLoadBalancerArn: ZIO[Any, AwsError, LoadBalancerArn] =
      AwsError.unwrapOptionField("loadBalancerArn", loadBalancerArn)
    def getTargetGroupArns: ZIO[Any, AwsError, List[TargetGroupArn]] =
      AwsError.unwrapOptionField("targetGroupArns", targetGroupArns)
    def getNames: ZIO[Any, AwsError, List[TargetGroupName]] =
      AwsError.unwrapOptionField("names", names)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsRequest.ReadOnly {
    override val loadBalancerArn: Optional[LoadBalancerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerArn())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerArn(value)
        )
    override val targetGroupArns: Optional[List[TargetGroupArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetGroupArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupArn(item)
          }.toList
        )
    override val names: Optional[List[TargetGroupName]] = zio.aws.core.internal
      .optionalFromNullable(impl.names())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupName(item)
        }.toList
      )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.PageSize(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest
  ): zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
