package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupArn
import scala.jdk.CollectionConverters._
final case class DescribeTargetGroupAttributesRequest(
    targetGroupArn: TargetGroupArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest = {
    import DescribeTargetGroupAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest
      .builder()
      .targetGroupArn(TargetGroupArn.unwrap(targetGroupArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest
      .wrap(buildAwsValue())
}
object DescribeTargetGroupAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest =
      zio.aws.elasticloadbalancingv2.model
        .DescribeTargetGroupAttributesRequest(targetGroupArn)
    def targetGroupArn: TargetGroupArn
    def getTargetGroupArn: ZIO[Any, Nothing, TargetGroupArn] =
      ZIO.succeed(targetGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest.ReadOnly {
    override val targetGroupArn: TargetGroupArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .TargetGroupArn(impl.targetGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest
  ): zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
