package zio.aws.elasticloadbalancingv2.model
import zio.aws.elasticloadbalancingv2.model.primitives.{
  ActionOrder,
  TargetGroupArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Action(
    `type`: zio.aws.elasticloadbalancingv2.model.ActionTypeEnum,
    targetGroupArn: Optional[TargetGroupArn] = Optional.Absent,
    authenticateOidcConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConfig
    ] = Optional.Absent,
    authenticateCognitoConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig
    ] = Optional.Absent,
    order: Optional[ActionOrder] = Optional.Absent,
    redirectConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.RedirectActionConfig
    ] = Optional.Absent,
    fixedResponseConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.FixedResponseActionConfig
    ] = Optional.Absent,
    forwardConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.ForwardActionConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.Action = {
    import Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Action
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        targetGroupArn.map(value =>
          TargetGroupArn.unwrap(value): java.lang.String
        )
      )(_.targetGroupArn)
      .optionallyWith(
        authenticateOidcConfig.map(value => value.buildAwsValue())
      )(_.authenticateOidcConfig)
      .optionallyWith(
        authenticateCognitoConfig.map(value => value.buildAwsValue())
      )(_.authenticateCognitoConfig)
      .optionallyWith(order.map(value => ActionOrder.unwrap(value): Integer))(
        _.order
      )
      .optionallyWith(redirectConfig.map(value => value.buildAwsValue()))(
        _.redirectConfig
      )
      .optionallyWith(fixedResponseConfig.map(value => value.buildAwsValue()))(
        _.fixedResponseConfig
      )
      .optionallyWith(forwardConfig.map(value => value.buildAwsValue()))(
        _.forwardConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.Action.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.Action.wrap(buildAwsValue())
}
object Action {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Action
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.Action =
      zio.aws.elasticloadbalancingv2.model.Action(
        `type`,
        targetGroupArn.map(value => value),
        authenticateOidcConfig.map(value => value.asEditable),
        authenticateCognitoConfig.map(value => value.asEditable),
        order.map(value => value),
        redirectConfig.map(value => value.asEditable),
        fixedResponseConfig.map(value => value.asEditable),
        forwardConfig.map(value => value.asEditable)
      )
    def `type`: zio.aws.elasticloadbalancingv2.model.ActionTypeEnum
    def targetGroupArn: Optional[TargetGroupArn]
    def authenticateOidcConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConfig.ReadOnly
    ]
    def authenticateCognitoConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig.ReadOnly
    ]
    def order: Optional[ActionOrder]
    def redirectConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.RedirectActionConfig.ReadOnly
    ]
    def fixedResponseConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.FixedResponseActionConfig.ReadOnly
    ]
    def forwardConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.ForwardActionConfig.ReadOnly
    ]
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.elasticloadbalancingv2.model.ActionTypeEnum
    ] = ZIO.succeed(`type`)
    def getTargetGroupArn: ZIO[Any, AwsError, TargetGroupArn] =
      AwsError.unwrapOptionField("targetGroupArn", targetGroupArn)
    def getAuthenticateOidcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "authenticateOidcConfig",
      authenticateOidcConfig
    )
    def getAuthenticateCognitoConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "authenticateCognitoConfig",
      authenticateCognitoConfig
    )
    def getOrder: ZIO[Any, AwsError, ActionOrder] =
      AwsError.unwrapOptionField("order", order)
    def getRedirectConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.RedirectActionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("redirectConfig", redirectConfig)
    def getFixedResponseConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.FixedResponseActionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("fixedResponseConfig", fixedResponseConfig)
    def getForwardConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.ForwardActionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("forwardConfig", forwardConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Action
  ) extends zio.aws.elasticloadbalancingv2.model.Action.ReadOnly {
    override val `type`: zio.aws.elasticloadbalancingv2.model.ActionTypeEnum =
      zio.aws.elasticloadbalancingv2.model.ActionTypeEnum.wrap(impl.`type`())
    override val targetGroupArn: Optional[TargetGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetGroupArn())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupArn(value)
        )
    override val authenticateOidcConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.authenticateOidcConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConfig
          .wrap(value)
      )
    override val authenticateCognitoConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.authenticateCognitoConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig
          .wrap(value)
      )
    override val order: Optional[ActionOrder] = zio.aws.core.internal
      .optionalFromNullable(impl.order())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.ActionOrder(value)
      )
    override val redirectConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.RedirectActionConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.redirectConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.RedirectActionConfig.wrap(value)
      )
    override val fixedResponseConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.FixedResponseActionConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fixedResponseConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.FixedResponseActionConfig
          .wrap(value)
      )
    override val forwardConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.ForwardActionConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.forwardConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.ForwardActionConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Action
  ): zio.aws.elasticloadbalancingv2.model.Action.ReadOnly = new Wrapper(impl)
}
