package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyRuleResponse(
    rules: Optional[Iterable[zio.aws.elasticloadbalancingv2.model.Rule]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleResponse = {
    import ModifyRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleResponse
      .builder()
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.ModifyRuleResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.ModifyRuleResponse
      .wrap(buildAwsValue())
}
object ModifyRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.ModifyRuleResponse =
      zio.aws.elasticloadbalancingv2.model.ModifyRuleResponse(
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def rules
        : Optional[List[zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly]]
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleResponse
  ) extends zio.aws.elasticloadbalancingv2.model.ModifyRuleResponse.ReadOnly {
    override val rules
        : Optional[List[zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Rule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleResponse
  ): zio.aws.elasticloadbalancingv2.model.ModifyRuleResponse.ReadOnly =
    new Wrapper(impl)
}
