package zio.aws.elasticloadbalancingv2.model
import zio.aws.elasticloadbalancingv2.model.primitives.{
  PageSize,
  Marker,
  ListenerArn,
  LoadBalancerArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeListenersRequest(
    loadBalancerArn: Optional[LoadBalancerArn] = Optional.Absent,
    listenerArns: Optional[Iterable[ListenerArn]] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent,
    pageSize: Optional[PageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest = {
    import DescribeListenersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest
      .builder()
      .optionallyWith(
        loadBalancerArn.map(value =>
          LoadBalancerArn.unwrap(value): java.lang.String
        )
      )(_.loadBalancerArn)
      .optionallyWith(
        listenerArns.map(value =>
          value.map { item =>
            ListenerArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.listenerArns)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeListenersRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeListenersRequest
      .wrap(buildAwsValue())
}
object DescribeListenersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeListenersRequest =
      zio.aws.elasticloadbalancingv2.model.DescribeListenersRequest(
        loadBalancerArn.map(value => value),
        listenerArns.map(value => value),
        marker.map(value => value),
        pageSize.map(value => value)
      )
    def loadBalancerArn: Optional[LoadBalancerArn]
    def listenerArns: Optional[List[ListenerArn]]
    def marker: Optional[Marker]
    def pageSize: Optional[PageSize]
    def getLoadBalancerArn: ZIO[Any, AwsError, LoadBalancerArn] =
      AwsError.unwrapOptionField("loadBalancerArn", loadBalancerArn)
    def getListenerArns: ZIO[Any, AwsError, List[ListenerArn]] =
      AwsError.unwrapOptionField("listenerArns", listenerArns)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeListenersRequest.ReadOnly {
    override val loadBalancerArn: Optional[LoadBalancerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerArn())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerArn(value)
        )
    override val listenerArns: Optional[List[ListenerArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listenerArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.primitives.ListenerArn(item)
          }.toList
        )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.PageSize(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest
  ): zio.aws.elasticloadbalancingv2.model.DescribeListenersRequest.ReadOnly =
    new Wrapper(impl)
}
