package zio.aws.elasticloadbalancingv2
import zio.aws.elasticloadbalancingv2.model.DescribeAccountLimitsResponse.ReadOnly
import zio.aws.elasticloadbalancingv2.model.{
  ModifyListenerRequest,
  DescribeRulesRequest,
  DescribeListenerCertificatesRequest,
  SetRulePrioritiesRequest,
  ModifyTargetGroupAttributesRequest,
  RegisterTargetsRequest,
  DescribeSslPoliciesRequest,
  SetSubnetsRequest,
  SetIpAddressTypeRequest,
  DescribeTargetHealthRequest,
  RemoveListenerCertificatesRequest,
  DescribeLoadBalancerAttributesRequest,
  DescribeTargetGroupAttributesRequest,
  DeregisterTargetsRequest,
  AddTagsRequest,
  CreateRuleRequest,
  DescribeListenersRequest,
  SetSecurityGroupsRequest,
  AddListenerCertificatesRequest,
  DeleteRuleRequest,
  CreateLoadBalancerRequest,
  ModifyLoadBalancerAttributesRequest,
  DescribeTagsRequest,
  DeleteLoadBalancerRequest,
  DescribeTargetGroupsRequest,
  DescribeLoadBalancersRequest,
  CreateTargetGroupRequest,
  ModifyRuleRequest,
  DescribeAccountLimitsRequest,
  DeleteListenerRequest,
  CreateListenerRequest,
  ModifyTargetGroupRequest,
  DeleteTargetGroupRequest,
  RemoveTagsRequest
}
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2AsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object ElasticLoadBalancingV2Mock extends Mock[ElasticLoadBalancingV2] {
  object AddListenerCertificates
      extends Effect[
        AddListenerCertificatesRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.AddListenerCertificatesResponse.ReadOnly
      ]
  object DescribeTags
      extends Effect[
        DescribeTagsRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.DescribeTagsResponse.ReadOnly
      ]
  object DeleteTargetGroup
      extends Effect[
        DeleteTargetGroupRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.DeleteTargetGroupResponse.ReadOnly
      ]
  object DescribeLoadBalancerAttributes
      extends Effect[
        DescribeLoadBalancerAttributesRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse.ReadOnly
      ]
  object DescribeListenerCertificates
      extends Effect[
        DescribeListenerCertificatesRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse.ReadOnly
      ]
  object DeregisterTargets
      extends Effect[
        DeregisterTargetsRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.DeregisterTargetsResponse.ReadOnly
      ]
  object DescribeTargetGroups
      extends Stream[
        DescribeTargetGroupsRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.TargetGroup.ReadOnly
      ]
  object DescribeTargetGroupsPaginated
      extends Effect[
        DescribeTargetGroupsRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse.ReadOnly
      ]
  object AddTags
      extends Effect[
        AddTagsRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.AddTagsResponse.ReadOnly
      ]
  object SetSecurityGroups
      extends Effect[
        SetSecurityGroupsRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.SetSecurityGroupsResponse.ReadOnly
      ]
  object DeleteListener
      extends Effect[
        DeleteListenerRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.DeleteListenerResponse.ReadOnly
      ]
  object DescribeAccountLimits
      extends Effect[DescribeAccountLimitsRequest, AwsError, ReadOnly]
  object DescribeSSLPolicies
      extends Effect[
        DescribeSslPoliciesRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesResponse.ReadOnly
      ]
  object DeleteLoadBalancer
      extends Effect[
        DeleteLoadBalancerRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.DeleteLoadBalancerResponse.ReadOnly
      ]
  object SetRulePriorities
      extends Effect[
        SetRulePrioritiesRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesResponse.ReadOnly
      ]
  object DeleteRule
      extends Effect[
        DeleteRuleRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.DeleteRuleResponse.ReadOnly
      ]
  object RegisterTargets
      extends Effect[
        RegisterTargetsRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.RegisterTargetsResponse.ReadOnly
      ]
  object CreateTargetGroup
      extends Effect[
        CreateTargetGroupRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.CreateTargetGroupResponse.ReadOnly
      ]
  object RemoveTags
      extends Effect[
        RemoveTagsRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.RemoveTagsResponse.ReadOnly
      ]
  object CreateListener
      extends Effect[
        CreateListenerRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.CreateListenerResponse.ReadOnly
      ]
  object ModifyLoadBalancerAttributes
      extends Effect[
        ModifyLoadBalancerAttributesRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse.ReadOnly
      ]
  object DescribeTargetGroupAttributes
      extends Effect[
        DescribeTargetGroupAttributesRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse.ReadOnly
      ]
  object DescribeListeners
      extends Stream[
        DescribeListenersRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly
      ]
  object DescribeListenersPaginated
      extends Effect[
        DescribeListenersRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.DescribeListenersResponse.ReadOnly
      ]
  object ModifyListener
      extends Effect[
        ModifyListenerRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.ModifyListenerResponse.ReadOnly
      ]
  object ModifyRule
      extends Effect[
        ModifyRuleRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.ModifyRuleResponse.ReadOnly
      ]
  object ModifyTargetGroup
      extends Effect[
        ModifyTargetGroupRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupResponse.ReadOnly
      ]
  object DescribeTargetHealth
      extends Effect[
        DescribeTargetHealthRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthResponse.ReadOnly
      ]
  object ModifyTargetGroupAttributes
      extends Effect[
        ModifyTargetGroupAttributesRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupAttributesResponse.ReadOnly
      ]
  object SetIpAddressType
      extends Effect[
        SetIpAddressTypeRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.SetIpAddressTypeResponse.ReadOnly
      ]
  object RemoveListenerCertificates
      extends Effect[
        RemoveListenerCertificatesRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.RemoveListenerCertificatesResponse.ReadOnly
      ]
  object DescribeRules
      extends Effect[
        DescribeRulesRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.DescribeRulesResponse.ReadOnly
      ]
  object SetSubnets
      extends Effect[
        SetSubnetsRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.SetSubnetsResponse.ReadOnly
      ]
  object CreateLoadBalancer
      extends Effect[
        CreateLoadBalancerRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerResponse.ReadOnly
      ]
  object DescribeLoadBalancers
      extends Stream[
        DescribeLoadBalancersRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly
      ]
  object DescribeLoadBalancersPaginated
      extends Effect[
        DescribeLoadBalancersRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse.ReadOnly
      ]
  object CreateRule
      extends Effect[
        CreateRuleRequest,
        AwsError,
        zio.aws.elasticloadbalancingv2.model.CreateRuleResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ElasticLoadBalancingV2] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ElasticLoadBalancingV2] { rts =>
        zio.ZIO.succeed {
          new ElasticLoadBalancingV2 {
            val api: ElasticLoadBalancingV2AsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ElasticLoadBalancingV2 = this
            def addListenerCertificates(
                request: AddListenerCertificatesRequest
            ): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.AddListenerCertificatesResponse.ReadOnly
            ] = proxy(AddListenerCertificates, request)
            def describeTags(request: DescribeTagsRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.DescribeTagsResponse.ReadOnly
            ] = proxy(DescribeTags, request)
            def deleteTargetGroup(request: DeleteTargetGroupRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.DeleteTargetGroupResponse.ReadOnly
            ] = proxy(DeleteTargetGroup, request)
            def describeLoadBalancerAttributes(
                request: DescribeLoadBalancerAttributesRequest
            ): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse.ReadOnly
            ] = proxy(DescribeLoadBalancerAttributes, request)
            def describeListenerCertificates(
                request: DescribeListenerCertificatesRequest
            ): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse.ReadOnly
            ] = proxy(DescribeListenerCertificates, request)
            def deregisterTargets(request: DeregisterTargetsRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.DeregisterTargetsResponse.ReadOnly
            ] = proxy(DeregisterTargets, request)
            def describeTargetGroups(
                request: DescribeTargetGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.elasticloadbalancingv2.model.TargetGroup.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeTargetGroups, request))
            def describeTargetGroupsPaginated(
                request: DescribeTargetGroupsRequest
            ): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse.ReadOnly
            ] = proxy(DescribeTargetGroupsPaginated, request)
            def addTags(request: AddTagsRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.AddTagsResponse.ReadOnly
            ] = proxy(AddTags, request)
            def setSecurityGroups(request: SetSecurityGroupsRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.SetSecurityGroupsResponse.ReadOnly
            ] = proxy(SetSecurityGroups, request)
            def deleteListener(request: DeleteListenerRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.DeleteListenerResponse.ReadOnly
            ] = proxy(DeleteListener, request)
            def describeAccountLimits(
                request: DescribeAccountLimitsRequest
            ): IO[AwsError, ReadOnly] = proxy(DescribeAccountLimits, request)
            def describeSSLPolicies(request: DescribeSslPoliciesRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesResponse.ReadOnly
            ] = proxy(DescribeSSLPolicies, request)
            def deleteLoadBalancer(request: DeleteLoadBalancerRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.DeleteLoadBalancerResponse.ReadOnly
            ] = proxy(DeleteLoadBalancer, request)
            def setRulePriorities(request: SetRulePrioritiesRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesResponse.ReadOnly
            ] = proxy(SetRulePriorities, request)
            def deleteRule(request: DeleteRuleRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.DeleteRuleResponse.ReadOnly
            ] = proxy(DeleteRule, request)
            def registerTargets(request: RegisterTargetsRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.RegisterTargetsResponse.ReadOnly
            ] = proxy(RegisterTargets, request)
            def createTargetGroup(request: CreateTargetGroupRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.CreateTargetGroupResponse.ReadOnly
            ] = proxy(CreateTargetGroup, request)
            def removeTags(request: RemoveTagsRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.RemoveTagsResponse.ReadOnly
            ] = proxy(RemoveTags, request)
            def createListener(request: CreateListenerRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.CreateListenerResponse.ReadOnly
            ] = proxy(CreateListener, request)
            def modifyLoadBalancerAttributes(
                request: ModifyLoadBalancerAttributesRequest
            ): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse.ReadOnly
            ] = proxy(ModifyLoadBalancerAttributes, request)
            def describeTargetGroupAttributes(
                request: DescribeTargetGroupAttributesRequest
            ): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse.ReadOnly
            ] = proxy(DescribeTargetGroupAttributes, request)
            def describeListeners(request: DescribeListenersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeListeners, request))
            def describeListenersPaginated(
                request: DescribeListenersRequest
            ): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.DescribeListenersResponse.ReadOnly
            ] = proxy(DescribeListenersPaginated, request)
            def modifyListener(request: ModifyListenerRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.ModifyListenerResponse.ReadOnly
            ] = proxy(ModifyListener, request)
            def modifyRule(request: ModifyRuleRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.ModifyRuleResponse.ReadOnly
            ] = proxy(ModifyRule, request)
            def modifyTargetGroup(request: ModifyTargetGroupRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupResponse.ReadOnly
            ] = proxy(ModifyTargetGroup, request)
            def describeTargetHealth(request: DescribeTargetHealthRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthResponse.ReadOnly
            ] = proxy(DescribeTargetHealth, request)
            def modifyTargetGroupAttributes(
                request: ModifyTargetGroupAttributesRequest
            ): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupAttributesResponse.ReadOnly
            ] = proxy(ModifyTargetGroupAttributes, request)
            def setIpAddressType(request: SetIpAddressTypeRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.SetIpAddressTypeResponse.ReadOnly
            ] = proxy(SetIpAddressType, request)
            def removeListenerCertificates(
                request: RemoveListenerCertificatesRequest
            ): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.RemoveListenerCertificatesResponse.ReadOnly
            ] = proxy(RemoveListenerCertificates, request)
            def describeRules(request: DescribeRulesRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.DescribeRulesResponse.ReadOnly
            ] = proxy(DescribeRules, request)
            def setSubnets(request: SetSubnetsRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.SetSubnetsResponse.ReadOnly
            ] = proxy(SetSubnets, request)
            def createLoadBalancer(request: CreateLoadBalancerRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerResponse.ReadOnly
            ] = proxy(CreateLoadBalancer, request)
            def describeLoadBalancers(
                request: DescribeLoadBalancersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeLoadBalancers, request))
            def describeLoadBalancersPaginated(
                request: DescribeLoadBalancersRequest
            ): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse.ReadOnly
            ] = proxy(DescribeLoadBalancersPaginated, request)
            def createRule(request: CreateRuleRequest): IO[
              AwsError,
              zio.aws.elasticloadbalancingv2.model.CreateRuleResponse.ReadOnly
            ] = proxy(CreateRule, request)
          }
        }
      }
    }
  }
}
