package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupArn
import scala.jdk.CollectionConverters._
final case class DeregisterTargetsRequest(
    targetGroupArn: TargetGroupArn,
    targets: Iterable[zio.aws.elasticloadbalancingv2.model.TargetDescription]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest = {
    import DeregisterTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest
      .builder()
      .targetGroupArn(TargetGroupArn.unwrap(targetGroupArn): java.lang.String)
      .targets(targets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DeregisterTargetsRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DeregisterTargetsRequest
      .wrap(buildAwsValue())
}
object DeregisterTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DeregisterTargetsRequest =
      zio.aws.elasticloadbalancingv2.model.DeregisterTargetsRequest(
        targetGroupArn,
        targets.map { item =>
          item.asEditable
        }
      )
    def targetGroupArn: TargetGroupArn
    def targets
        : List[zio.aws.elasticloadbalancingv2.model.TargetDescription.ReadOnly]
    def getTargetGroupArn: ZIO[Any, Nothing, TargetGroupArn] =
      ZIO.succeed(targetGroupArn)
    def getTargets: ZIO[Any, Nothing, List[
      zio.aws.elasticloadbalancingv2.model.TargetDescription.ReadOnly
    ]] = ZIO.succeed(targets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DeregisterTargetsRequest.ReadOnly {
    override val targetGroupArn: TargetGroupArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .TargetGroupArn(impl.targetGroupArn())
    override val targets: List[
      zio.aws.elasticloadbalancingv2.model.TargetDescription.ReadOnly
    ] = impl
      .targets()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancingv2.model.TargetDescription.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest
  ): zio.aws.elasticloadbalancingv2.model.DeregisterTargetsRequest.ReadOnly =
    new Wrapper(impl)
}
