package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetRulePrioritiesRequest(
    rulePriorities: Iterable[
      zio.aws.elasticloadbalancingv2.model.RulePriorityPair
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest = {
    import SetRulePrioritiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest
      .builder()
      .rulePriorities(rulePriorities.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesRequest
      .wrap(buildAwsValue())
}
object SetRulePrioritiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesRequest =
      zio.aws.elasticloadbalancingv2.model
        .SetRulePrioritiesRequest(rulePriorities.map { item =>
          item.asEditable
        })
    def rulePriorities
        : List[zio.aws.elasticloadbalancingv2.model.RulePriorityPair.ReadOnly]
    def getRulePriorities: ZIO[Any, Nothing, List[
      zio.aws.elasticloadbalancingv2.model.RulePriorityPair.ReadOnly
    ]] = ZIO.succeed(rulePriorities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest
  ) extends zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesRequest.ReadOnly {
    override val rulePriorities
        : List[zio.aws.elasticloadbalancingv2.model.RulePriorityPair.ReadOnly] =
      impl
        .rulePriorities()
        .asScala
        .map { item =>
          zio.aws.elasticloadbalancingv2.model.RulePriorityPair.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest
  ): zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesRequest.ReadOnly =
    new Wrapper(impl)
}
