package zio.aws.elasticloadbalancingv2.model
import scala.jdk.CollectionConverters._
sealed trait RedirectActionStatusCodeEnum {
  def unwrap: software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum
}
object RedirectActionStatusCodeEnum {
  def wrap(
      value: software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum
  ): zio.aws.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum =
    value match {
      case software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum.HTTP_301 =>
        val r = HTTP_301
        r
      case software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum.HTTP_302 =>
        val r = HTTP_302
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTP_301
      extends zio.aws.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum.HTTP_301
  }
  case object HTTP_302
      extends zio.aws.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum.HTTP_302
  }
}
