package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ForwardActionConfig(
    targetGroups: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.TargetGroupTuple]
    ] = Optional.Absent,
    targetGroupStickinessConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig = {
    import ForwardActionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig
      .builder()
      .optionallyWith(
        targetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetGroups)
      .optionallyWith(
        targetGroupStickinessConfig.map(value => value.buildAwsValue())
      )(_.targetGroupStickinessConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.ForwardActionConfig.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.ForwardActionConfig
      .wrap(buildAwsValue())
}
object ForwardActionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.ForwardActionConfig =
      zio.aws.elasticloadbalancingv2.model.ForwardActionConfig(
        targetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetGroupStickinessConfig.map(value => value.asEditable)
      )
    def targetGroups: Optional[
      List[zio.aws.elasticloadbalancingv2.model.TargetGroupTuple.ReadOnly]
    ]
    def targetGroupStickinessConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig.ReadOnly
    ]
    def getTargetGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.TargetGroupTuple.ReadOnly
    ]] = AwsError.unwrapOptionField("targetGroups", targetGroups)
    def getTargetGroupStickinessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "targetGroupStickinessConfig",
      targetGroupStickinessConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig
  ) extends zio.aws.elasticloadbalancingv2.model.ForwardActionConfig.ReadOnly {
    override val targetGroups: Optional[
      List[zio.aws.elasticloadbalancingv2.model.TargetGroupTuple.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.TargetGroupTuple.wrap(item)
        }.toList
      )
    override val targetGroupStickinessConfig: Optional[
      zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetGroupStickinessConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig
  ): zio.aws.elasticloadbalancingv2.model.ForwardActionConfig.ReadOnly =
    new Wrapper(impl)
}
