package zio.aws.elasticloadbalancingv2.model
import zio.aws.elasticloadbalancingv2.model.primitives.{
  PageSize,
  Marker,
  ListenerArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeListenerCertificatesRequest(
    listenerArn: ListenerArn,
    marker: Optional[Marker] = Optional.Absent,
    pageSize: Optional[PageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest = {
    import DescribeListenerCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest
      .builder()
      .listenerArn(ListenerArn.unwrap(listenerArn): java.lang.String)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest
      .wrap(buildAwsValue())
}
object DescribeListenerCertificatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest =
      zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest(
        listenerArn,
        marker.map(value => value),
        pageSize.map(value => value)
      )
    def listenerArn: ListenerArn
    def marker: Optional[Marker]
    def pageSize: Optional[PageSize]
    def getListenerArn: ZIO[Any, Nothing, ListenerArn] =
      ZIO.succeed(listenerArn)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest.ReadOnly {
    override val listenerArn: ListenerArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .ListenerArn(impl.listenerArn())
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.PageSize(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest
  ): zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest.ReadOnly =
    new Wrapper(impl)
}
