package zio.aws.elasticloadbalancingv2.model
import scala.jdk.CollectionConverters._
sealed trait LoadBalancerStateEnum {
  def unwrap: software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum
}
object LoadBalancerStateEnum {
  def wrap(
      value: software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum
  ): zio.aws.elasticloadbalancingv2.model.LoadBalancerStateEnum = value match {
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum.PROVISIONING =>
      val r = provisioning
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum.ACTIVE_IMPAIRED =>
      val r = active_impaired
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum.FAILED =>
      val r = failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticloadbalancingv2.model.LoadBalancerStateEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object active
      extends zio.aws.elasticloadbalancingv2.model.LoadBalancerStateEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum.ACTIVE
  }
  case object provisioning
      extends zio.aws.elasticloadbalancingv2.model.LoadBalancerStateEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum.PROVISIONING
  }
  case object active_impaired
      extends zio.aws.elasticloadbalancingv2.model.LoadBalancerStateEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum.ACTIVE_IMPAIRED
  }
  case object failed
      extends zio.aws.elasticloadbalancingv2.model.LoadBalancerStateEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum.FAILED
  }
}
