package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticloadbalancingv2.model.primitives.{
  StringValue,
  SslPolicyName,
  SslProtocol
}
import scala.jdk.CollectionConverters._
final case class SslPolicy(
    sslProtocols: Optional[Iterable[SslProtocol]] = Optional.Absent,
    ciphers: Optional[Iterable[zio.aws.elasticloadbalancingv2.model.Cipher]] =
      Optional.Absent,
    name: Optional[SslPolicyName] = Optional.Absent,
    supportedLoadBalancerTypes: Optional[Iterable[StringValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicy = {
    import SslPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicy
      .builder()
      .optionallyWith(
        sslProtocols.map(value =>
          value.map { item =>
            SslProtocol.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sslProtocols)
      .optionallyWith(
        ciphers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ciphers)
      .optionallyWith(
        name.map(value => SslPolicyName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        supportedLoadBalancerTypes.map(value =>
          value.map { item =>
            StringValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedLoadBalancerTypes)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.SslPolicy.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.SslPolicy.wrap(buildAwsValue())
}
object SslPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.SslPolicy =
      zio.aws.elasticloadbalancingv2.model.SslPolicy(
        sslProtocols.map(value => value),
        ciphers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        supportedLoadBalancerTypes.map(value => value)
      )
    def sslProtocols: Optional[List[SslProtocol]]
    def ciphers
        : Optional[List[zio.aws.elasticloadbalancingv2.model.Cipher.ReadOnly]]
    def name: Optional[SslPolicyName]
    def supportedLoadBalancerTypes: Optional[List[StringValue]]
    def getSslProtocols: ZIO[Any, AwsError, List[SslProtocol]] =
      AwsError.unwrapOptionField("sslProtocols", sslProtocols)
    def getCiphers: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Cipher.ReadOnly
    ]] = AwsError.unwrapOptionField("ciphers", ciphers)
    def getName: ZIO[Any, AwsError, SslPolicyName] =
      AwsError.unwrapOptionField("name", name)
    def getSupportedLoadBalancerTypes: ZIO[Any, AwsError, List[StringValue]] =
      AwsError.unwrapOptionField(
        "supportedLoadBalancerTypes",
        supportedLoadBalancerTypes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicy
  ) extends zio.aws.elasticloadbalancingv2.model.SslPolicy.ReadOnly {
    override val sslProtocols: Optional[List[SslProtocol]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sslProtocols())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.primitives.SslProtocol(item)
          }.toList
        )
    override val ciphers
        : Optional[List[zio.aws.elasticloadbalancingv2.model.Cipher.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ciphers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Cipher.wrap(item)
          }.toList
        )
    override val name: Optional[SslPolicyName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.SslPolicyName(value)
      )
    override val supportedLoadBalancerTypes: Optional[List[StringValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedLoadBalancerTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.primitives.StringValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicy
  ): zio.aws.elasticloadbalancingv2.model.SslPolicy.ReadOnly = new Wrapper(impl)
}
