package zio.aws.elasticloadbalancingv2.model
import scala.jdk.CollectionConverters._
sealed trait ActionTypeEnum {
  def unwrap: software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum
}
object ActionTypeEnum {
  def wrap(
      value: software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum
  ): zio.aws.elasticloadbalancingv2.model.ActionTypeEnum = value match {
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum.FORWARD =>
      val r = forward
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum.AUTHENTICATE_OIDC =>
      val r = `authenticate-oidc`
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum.AUTHENTICATE_COGNITO =>
      val r = `authenticate-cognito`
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum.REDIRECT =>
      val r = redirect
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum.FIXED_RESPONSE =>
      val r = `fixed-response`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticloadbalancingv2.model.ActionTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object forward
      extends zio.aws.elasticloadbalancingv2.model.ActionTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum.FORWARD
  }
  case object `authenticate-oidc`
      extends zio.aws.elasticloadbalancingv2.model.ActionTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum.AUTHENTICATE_OIDC
  }
  case object `authenticate-cognito`
      extends zio.aws.elasticloadbalancingv2.model.ActionTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum.AUTHENTICATE_COGNITO
  }
  case object redirect
      extends zio.aws.elasticloadbalancingv2.model.ActionTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum.REDIRECT
  }
  case object `fixed-response`
      extends zio.aws.elasticloadbalancingv2.model.ActionTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum.FIXED_RESPONSE
  }
}
