package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  StringValue,
  HttpHeaderConditionName
}
import scala.jdk.CollectionConverters._
final case class HttpHeaderConditionConfig(
    httpHeaderName: Option[HttpHeaderConditionName] = None,
    values: Option[Iterable[StringValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig = {
    import HttpHeaderConditionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig
      .builder()
      .optionallyWith(
        httpHeaderName.map(value =>
          HttpHeaderConditionName.unwrap(value): java.lang.String
        )
      )(_.httpHeaderName)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            StringValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.HttpHeaderConditionConfig.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.HttpHeaderConditionConfig
      .wrap(buildAwsValue())
}
object HttpHeaderConditionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.HttpHeaderConditionConfig =
      zio.aws.elasticloadbalancingv2.model.HttpHeaderConditionConfig(
        httpHeaderName.map(value => value),
        values.map(value => value)
      )
    def httpHeaderName: Option[HttpHeaderConditionName]
    def values: Option[List[StringValue]]
    def getHttpHeaderName: ZIO[Any, AwsError, HttpHeaderConditionName] =
      AwsError.unwrapOptionField("httpHeaderName", httpHeaderName)
    def getValues: ZIO[Any, AwsError, List[StringValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig
  ) extends zio.aws.elasticloadbalancingv2.model.HttpHeaderConditionConfig.ReadOnly {
    override val httpHeaderName: Option[HttpHeaderConditionName] = scala
      .Option(impl.httpHeaderName())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .HttpHeaderConditionName(value)
      )
    override val values: Option[List[StringValue]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.StringValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig
  ): zio.aws.elasticloadbalancingv2.model.HttpHeaderConditionConfig.ReadOnly =
    new Wrapper(impl)
}
