package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.Marker
import scala.jdk.CollectionConverters._
final case class DescribeTargetGroupsResponse(
    targetGroups: Option[
      Iterable[zio.aws.elasticloadbalancingv2.model.TargetGroup]
    ] = None,
    nextMarker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse = {
    import DescribeTargetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse
      .builder()
      .optionallyWith(
        targetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetGroups)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeTargetGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse =
      zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse(
        targetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def targetGroups: Option[
      List[zio.aws.elasticloadbalancingv2.model.TargetGroup.ReadOnly]
    ]
    def nextMarker: Option[Marker]
    def getTargetGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.TargetGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("targetGroups", targetGroups)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse.ReadOnly {
    override val targetGroups: Option[
      List[zio.aws.elasticloadbalancingv2.model.TargetGroup.ReadOnly]
    ] = scala
      .Option(impl.targetGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.TargetGroup.wrap(item)
        }.toList
      )
    override val nextMarker: Option[Marker] = scala
      .Option(impl.nextMarker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse
  ): zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
