package zio.aws.elasticloadbalancingv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  PageSize,
  Marker,
  LoadBalancerName,
  LoadBalancerArn
}
import scala.jdk.CollectionConverters._
final case class DescribeLoadBalancersRequest(
    loadBalancerArns: Option[Iterable[LoadBalancerArn]] = None,
    names: Option[Iterable[LoadBalancerName]] = None,
    marker: Option[Marker] = None,
    pageSize: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest = {
    import DescribeLoadBalancersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest
      .builder()
      .optionallyWith(
        loadBalancerArns.map(value =>
          value.map { item =>
            LoadBalancerArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.loadBalancerArns)
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            LoadBalancerName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersRequest
      .wrap(buildAwsValue())
}
object DescribeLoadBalancersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersRequest =
      zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersRequest(
        loadBalancerArns.map(value => value),
        names.map(value => value),
        marker.map(value => value),
        pageSize.map(value => value)
      )
    def loadBalancerArns: Option[List[LoadBalancerArn]]
    def names: Option[List[LoadBalancerName]]
    def marker: Option[Marker]
    def pageSize: Option[PageSize]
    def getLoadBalancerArns: ZIO[Any, AwsError, List[LoadBalancerArn]] =
      AwsError.unwrapOptionField("loadBalancerArns", loadBalancerArns)
    def getNames: ZIO[Any, AwsError, List[LoadBalancerName]] =
      AwsError.unwrapOptionField("names", names)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersRequest.ReadOnly {
    override val loadBalancerArns: Option[List[LoadBalancerArn]] = scala
      .Option(impl.loadBalancerArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerArn(item)
        }.toList
      )
    override val names: Option[List[LoadBalancerName]] = scala
      .Option(impl.names())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerName(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.PageSize(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest
  ): zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersRequest.ReadOnly =
    new Wrapper(impl)
}
