package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateListenerResponse(
    listeners: Option[Iterable[zio.aws.elasticloadbalancingv2.model.Listener]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerResponse = {
    import CreateListenerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerResponse
      .builder()
      .optionallyWith(
        listeners.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.listeners)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.CreateListenerResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.CreateListenerResponse
      .wrap(buildAwsValue())
}
object CreateListenerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.CreateListenerResponse =
      zio.aws.elasticloadbalancingv2.model.CreateListenerResponse(
        listeners.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def listeners
        : Option[List[zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly]]
    def getListeners: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly
    ]] = AwsError.unwrapOptionField("listeners", listeners)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerResponse
  ) extends zio.aws.elasticloadbalancingv2.model.CreateListenerResponse.ReadOnly {
    override val listeners
        : Option[List[zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly]] =
      scala
        .Option(impl.listeners())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Listener.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerResponse
  ): zio.aws.elasticloadbalancingv2.model.CreateListenerResponse.ReadOnly =
    new Wrapper(impl)
}
