package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.StringValue
import scala.jdk.CollectionConverters._
final case class HostHeaderConditionConfig(
    values: Option[Iterable[StringValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.HostHeaderConditionConfig = {
    import HostHeaderConditionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.HostHeaderConditionConfig
      .builder()
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            StringValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.HostHeaderConditionConfig.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.HostHeaderConditionConfig
      .wrap(buildAwsValue())
}
object HostHeaderConditionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.HostHeaderConditionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.HostHeaderConditionConfig =
      zio.aws.elasticloadbalancingv2.model
        .HostHeaderConditionConfig(values.map(value => value))
    def values: Option[List[StringValue]]
    def getValues: ZIO[Any, AwsError, List[StringValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.HostHeaderConditionConfig
  ) extends zio.aws.elasticloadbalancingv2.model.HostHeaderConditionConfig.ReadOnly {
    override val values: Option[List[StringValue]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.StringValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.HostHeaderConditionConfig
  ): zio.aws.elasticloadbalancingv2.model.HostHeaderConditionConfig.ReadOnly =
    new Wrapper(impl)
}
