package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  IPv6Address,
  PrivateIPv4Address,
  AllocationId,
  IpAddress
}
import scala.jdk.CollectionConverters._
final case class LoadBalancerAddress(
    ipAddress: Option[IpAddress] = None,
    allocationId: Option[AllocationId] = None,
    privateIPv4Address: Option[PrivateIPv4Address] = None,
    iPv6Address: Option[IPv6Address] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAddress = {
    import LoadBalancerAddress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAddress
      .builder()
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        allocationId.map(value => AllocationId.unwrap(value): java.lang.String)
      )(_.allocationId)
      .optionallyWith(
        privateIPv4Address.map(value =>
          PrivateIPv4Address.unwrap(value): java.lang.String
        )
      )(_.privateIPv4Address)
      .optionallyWith(
        iPv6Address.map(value => IPv6Address.unwrap(value): java.lang.String)
      )(_.iPv6Address)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.LoadBalancerAddress.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.LoadBalancerAddress
      .wrap(buildAwsValue())
}
object LoadBalancerAddress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAddress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.LoadBalancerAddress =
      zio.aws.elasticloadbalancingv2.model.LoadBalancerAddress(
        ipAddress.map(value => value),
        allocationId.map(value => value),
        privateIPv4Address.map(value => value),
        iPv6Address.map(value => value)
      )
    def ipAddress: Option[IpAddress]
    def allocationId: Option[AllocationId]
    def privateIPv4Address: Option[PrivateIPv4Address]
    def iPv6Address: Option[IPv6Address]
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getAllocationId: ZIO[Any, AwsError, AllocationId] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getPrivateIPv4Address: ZIO[Any, AwsError, PrivateIPv4Address] =
      AwsError.unwrapOptionField("privateIPv4Address", privateIPv4Address)
    def getIPv6Address: ZIO[Any, AwsError, IPv6Address] =
      AwsError.unwrapOptionField("iPv6Address", iPv6Address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAddress
  ) extends zio.aws.elasticloadbalancingv2.model.LoadBalancerAddress.ReadOnly {
    override val ipAddress: Option[IpAddress] = scala
      .Option(impl.ipAddress())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.IpAddress(value)
      )
    override val allocationId: Option[AllocationId] = scala
      .Option(impl.allocationId())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.AllocationId(value)
      )
    override val privateIPv4Address: Option[PrivateIPv4Address] = scala
      .Option(impl.privateIPv4Address())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .PrivateIPv4Address(value)
      )
    override val iPv6Address: Option[IPv6Address] = scala
      .Option(impl.iPv6Address())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.IPv6Address(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAddress
  ): zio.aws.elasticloadbalancingv2.model.LoadBalancerAddress.ReadOnly =
    new Wrapper(impl)
}
