package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{IsDefault, RuleArn}
import scala.jdk.CollectionConverters._
final case class Rule(
    ruleArn: Option[RuleArn] = None,
    priority: Option[String] = None,
    conditions: Option[
      Iterable[zio.aws.elasticloadbalancingv2.model.RuleCondition]
    ] = None,
    actions: Option[Iterable[zio.aws.elasticloadbalancingv2.model.Action]] =
      None,
    isDefault: Option[IsDefault] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule
      .builder()
      .optionallyWith(
        ruleArn.map(value => RuleArn.unwrap(value): java.lang.String)
      )(_.ruleArn)
      .optionallyWith(priority.map(value => value: java.lang.String))(
        _.priority
      )
      .optionallyWith(
        conditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conditions)
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actions)
      .optionallyWith(
        isDefault.map(value => IsDefault.unwrap(value): java.lang.Boolean)
      )(_.isDefault)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.Rule =
      zio.aws.elasticloadbalancingv2.model.Rule(
        ruleArn.map(value => value),
        priority.map(value => value),
        conditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        actions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isDefault.map(value => value)
      )
    def ruleArn: Option[RuleArn]
    def priority: Option[String]
    def conditions: Option[
      List[zio.aws.elasticloadbalancingv2.model.RuleCondition.ReadOnly]
    ]
    def actions
        : Option[List[zio.aws.elasticloadbalancingv2.model.Action.ReadOnly]]
    def isDefault: Option[IsDefault]
    def getRuleArn: ZIO[Any, AwsError, RuleArn] =
      AwsError.unwrapOptionField("ruleArn", ruleArn)
    def getPriority: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("priority", priority)
    def getConditions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.RuleCondition.ReadOnly
    ]] = AwsError.unwrapOptionField("conditions", conditions)
    def getActions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Action.ReadOnly
    ]] = AwsError.unwrapOptionField("actions", actions)
    def getIsDefault: ZIO[Any, AwsError, IsDefault] =
      AwsError.unwrapOptionField("isDefault", isDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule
  ) extends zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly {
    override val ruleArn: Option[RuleArn] = scala
      .Option(impl.ruleArn())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.RuleArn(value)
      )
    override val priority: Option[String] =
      scala.Option(impl.priority()).map(value => value: String)
    override val conditions: Option[
      List[zio.aws.elasticloadbalancingv2.model.RuleCondition.ReadOnly]
    ] = scala
      .Option(impl.conditions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.RuleCondition.wrap(item)
        }.toList
      )
    override val actions
        : Option[List[zio.aws.elasticloadbalancingv2.model.Action.ReadOnly]] =
      scala
        .Option(impl.actions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Action.wrap(item)
          }.toList
        )
    override val isDefault: Option[IsDefault] = scala
      .Option(impl.isDefault())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.IsDefault(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule
  ): zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly = new Wrapper(impl)
}
