package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.Marker
import scala.jdk.CollectionConverters._
final case class DescribeSslPoliciesResponse(
    sslPolicies: Option[
      Iterable[zio.aws.elasticloadbalancingv2.model.SslPolicy]
    ] = None,
    nextMarker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesResponse = {
    import DescribeSslPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesResponse
      .builder()
      .optionallyWith(
        sslPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sslPolicies)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesResponse
      .wrap(buildAwsValue())
}
object DescribeSslPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesResponse =
      zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesResponse(
        sslPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def sslPolicies
        : Option[List[zio.aws.elasticloadbalancingv2.model.SslPolicy.ReadOnly]]
    def nextMarker: Option[Marker]
    def getSslPolicies: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.SslPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField("sslPolicies", sslPolicies)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesResponse
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesResponse.ReadOnly {
    override val sslPolicies: Option[
      List[zio.aws.elasticloadbalancingv2.model.SslPolicy.ReadOnly]
    ] = scala
      .Option(impl.sslPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.SslPolicy.wrap(item)
        }.toList
      )
    override val nextMarker: Option[Marker] = scala
      .Option(impl.nextMarker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesResponse
  ): zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
