package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.Marker
import scala.jdk.CollectionConverters._
final case class DescribeListenersResponse(
    listeners: Option[Iterable[zio.aws.elasticloadbalancingv2.model.Listener]] =
      None,
    nextMarker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse = {
    import DescribeListenersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse
      .builder()
      .optionallyWith(
        listeners.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.listeners)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeListenersResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeListenersResponse
      .wrap(buildAwsValue())
}
object DescribeListenersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeListenersResponse =
      zio.aws.elasticloadbalancingv2.model.DescribeListenersResponse(
        listeners.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def listeners
        : Option[List[zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly]]
    def nextMarker: Option[Marker]
    def getListeners: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly
    ]] = AwsError.unwrapOptionField("listeners", listeners)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeListenersResponse.ReadOnly {
    override val listeners
        : Option[List[zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly]] =
      scala
        .Option(impl.listeners())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Listener.wrap(item)
          }.toList
        )
    override val nextMarker: Option[Marker] = scala
      .Option(impl.nextMarker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse
  ): zio.aws.elasticloadbalancingv2.model.DescribeListenersResponse.ReadOnly =
    new Wrapper(impl)
}
