package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.Marker
import scala.jdk.CollectionConverters._
final case class DescribeAccountLimitsResponse(
    limits: Option[Iterable[zio.aws.elasticloadbalancingv2.model.Limit]] = None,
    nextMarker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse = {
    import DescribeAccountLimitsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse
      .builder()
      .optionallyWith(
        limits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.limits)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeAccountLimitsResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeAccountLimitsResponse
      .wrap(buildAwsValue())
}
object DescribeAccountLimitsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeAccountLimitsResponse =
      zio.aws.elasticloadbalancingv2.model.DescribeAccountLimitsResponse(
        limits.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def limits
        : Option[List[zio.aws.elasticloadbalancingv2.model.Limit.ReadOnly]]
    def nextMarker: Option[Marker]
    def getLimits: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Limit.ReadOnly
    ]] = AwsError.unwrapOptionField("limits", limits)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeAccountLimitsResponse.ReadOnly {
    override val limits
        : Option[List[zio.aws.elasticloadbalancingv2.model.Limit.ReadOnly]] =
      scala
        .Option(impl.limits())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Limit.wrap(item)
          }.toList
        )
    override val nextMarker: Option[Marker] = scala
      .Option(impl.nextMarker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse
  ): zio.aws.elasticloadbalancingv2.model.DescribeAccountLimitsResponse.ReadOnly =
    new Wrapper(impl)
}
