package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{Default, CertificateArn}
import scala.jdk.CollectionConverters._
final case class Certificate(
    certificateArn: Option[CertificateArn] = None,
    isDefault: Option[Default] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate = {
    import Certificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        isDefault.map(value => Default.unwrap(value): java.lang.Boolean)
      )(_.isDefault)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.Certificate.wrap(buildAwsValue())
}
object Certificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.Certificate =
      zio.aws.elasticloadbalancingv2.model.Certificate(
        certificateArn.map(value => value),
        isDefault.map(value => value)
      )
    def certificateArn: Option[CertificateArn]
    def isDefault: Option[Default]
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getIsDefault: ZIO[Any, AwsError, Default] =
      AwsError.unwrapOptionField("isDefault", isDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate
  ) extends zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly {
    override val certificateArn: Option[CertificateArn] = scala
      .Option(impl.certificateArn())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.CertificateArn(value)
      )
    override val isDefault: Option[Default] = scala
      .Option(impl.isDefault())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Default(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate
  ): zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly = new Wrapper(
    impl
  )
}
