package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class QueryStringConditionConfig(
    values: Option[
      Iterable[zio.aws.elasticloadbalancingv2.model.QueryStringKeyValuePair]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.QueryStringConditionConfig = {
    import QueryStringConditionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.QueryStringConditionConfig
      .builder()
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.QueryStringConditionConfig.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.QueryStringConditionConfig
      .wrap(buildAwsValue())
}
object QueryStringConditionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.QueryStringConditionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.QueryStringConditionConfig =
      zio.aws.elasticloadbalancingv2.model.QueryStringConditionConfig(
        values.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def values: Option[List[
      zio.aws.elasticloadbalancingv2.model.QueryStringKeyValuePair.ReadOnly
    ]]
    def getValues: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.QueryStringKeyValuePair.ReadOnly
    ]] = AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.QueryStringConditionConfig
  ) extends zio.aws.elasticloadbalancingv2.model.QueryStringConditionConfig.ReadOnly {
    override val values: Option[List[
      zio.aws.elasticloadbalancingv2.model.QueryStringKeyValuePair.ReadOnly
    ]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.QueryStringKeyValuePair
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.QueryStringConditionConfig
  ): zio.aws.elasticloadbalancingv2.model.QueryStringConditionConfig.ReadOnly =
    new Wrapper(impl)
}
