package zio.aws.elasticloadbalancingv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  PageSize,
  Marker,
  RuleArn,
  ListenerArn
}
import scala.jdk.CollectionConverters._
final case class DescribeRulesRequest(
    listenerArn: Option[ListenerArn] = None,
    ruleArns: Option[Iterable[RuleArn]] = None,
    marker: Option[Marker] = None,
    pageSize: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest = {
    import DescribeRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest
      .builder()
      .optionallyWith(
        listenerArn.map(value => ListenerArn.unwrap(value): java.lang.String)
      )(_.listenerArn)
      .optionallyWith(
        ruleArns.map(value =>
          value.map { item =>
            RuleArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ruleArns)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeRulesRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeRulesRequest
      .wrap(buildAwsValue())
}
object DescribeRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.DescribeRulesRequest =
      zio.aws.elasticloadbalancingv2.model.DescribeRulesRequest(
        listenerArn.map(value => value),
        ruleArns.map(value => value),
        marker.map(value => value),
        pageSize.map(value => value)
      )
    def listenerArn: Option[ListenerArn]
    def ruleArns: Option[List[RuleArn]]
    def marker: Option[Marker]
    def pageSize: Option[PageSize]
    def getListenerArn: ZIO[Any, AwsError, ListenerArn] =
      AwsError.unwrapOptionField("listenerArn", listenerArn)
    def getRuleArns: ZIO[Any, AwsError, List[RuleArn]] =
      AwsError.unwrapOptionField("ruleArns", ruleArns)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeRulesRequest.ReadOnly {
    override val listenerArn: Option[ListenerArn] = scala
      .Option(impl.listenerArn())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.ListenerArn(value)
      )
    override val ruleArns: Option[List[RuleArn]] = scala
      .Option(impl.ruleArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.RuleArn(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.PageSize(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest
  ): zio.aws.elasticloadbalancingv2.model.DescribeRulesRequest.ReadOnly =
    new Wrapper(impl)
}
