package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeLoadBalancerAttributesResponse(
    attributes: Option[
      Iterable[zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse = {
    import DescribeLoadBalancerAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse
      .wrap(buildAwsValue())
}
object DescribeLoadBalancerAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse =
      zio.aws.elasticloadbalancingv2.model
        .DescribeLoadBalancerAttributesResponse(
          attributes.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def attributes: Option[
      List[zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute.ReadOnly]
    ]
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse.ReadOnly {
    override val attributes: Option[
      List[zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute.ReadOnly]
    ] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse
  ): zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
