package zio.aws.elasticloadbalancingv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{RulePriority, RuleArn}
import scala.jdk.CollectionConverters._
final case class RulePriorityPair(
    ruleArn: Option[RuleArn] = None,
    priority: Option[RulePriority] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair = {
    import RulePriorityPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair
      .builder()
      .optionallyWith(
        ruleArn.map(value => RuleArn.unwrap(value): java.lang.String)
      )(_.ruleArn)
      .optionallyWith(
        priority.map(value => RulePriority.unwrap(value): Integer)
      )(_.priority)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.RulePriorityPair.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.RulePriorityPair.wrap(buildAwsValue())
}
object RulePriorityPair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.RulePriorityPair =
      zio.aws.elasticloadbalancingv2.model.RulePriorityPair(
        ruleArn.map(value => value),
        priority.map(value => value)
      )
    def ruleArn: Option[RuleArn]
    def priority: Option[RulePriority]
    def getRuleArn: ZIO[Any, AwsError, RuleArn] =
      AwsError.unwrapOptionField("ruleArn", ruleArn)
    def getPriority: ZIO[Any, AwsError, RulePriority] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair
  ) extends zio.aws.elasticloadbalancingv2.model.RulePriorityPair.ReadOnly {
    override val ruleArn: Option[RuleArn] = scala
      .Option(impl.ruleArn())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.RuleArn(value)
      )
    override val priority: Option[RulePriority] = scala
      .Option(impl.priority())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.RulePriority(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair
  ): zio.aws.elasticloadbalancingv2.model.RulePriorityPair.ReadOnly =
    new Wrapper(impl)
}
