package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.HealthCheckPort
import scala.jdk.CollectionConverters._
final case class TargetHealthDescription(
    target: Option[zio.aws.elasticloadbalancingv2.model.TargetDescription] =
      None,
    healthCheckPort: Option[HealthCheckPort] = None,
    targetHealth: Option[zio.aws.elasticloadbalancingv2.model.TargetHealth] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthDescription = {
    import TargetHealthDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthDescription
      .builder()
      .optionallyWith(target.map(value => value.buildAwsValue()))(_.target)
      .optionallyWith(
        healthCheckPort.map(value =>
          HealthCheckPort.unwrap(value): java.lang.String
        )
      )(_.healthCheckPort)
      .optionallyWith(targetHealth.map(value => value.buildAwsValue()))(
        _.targetHealth
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.TargetHealthDescription.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.TargetHealthDescription
      .wrap(buildAwsValue())
}
object TargetHealthDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.TargetHealthDescription =
      zio.aws.elasticloadbalancingv2.model.TargetHealthDescription(
        target.map(value => value.asEditable),
        healthCheckPort.map(value => value),
        targetHealth.map(value => value.asEditable)
      )
    def target: Option[
      zio.aws.elasticloadbalancingv2.model.TargetDescription.ReadOnly
    ]
    def healthCheckPort: Option[HealthCheckPort]
    def targetHealth
        : Option[zio.aws.elasticloadbalancingv2.model.TargetHealth.ReadOnly]
    def getTarget: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.TargetDescription.ReadOnly
    ] = AwsError.unwrapOptionField("target", target)
    def getHealthCheckPort: ZIO[Any, AwsError, HealthCheckPort] =
      AwsError.unwrapOptionField("healthCheckPort", healthCheckPort)
    def getTargetHealth: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.TargetHealth.ReadOnly
    ] = AwsError.unwrapOptionField("targetHealth", targetHealth)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthDescription
  ) extends zio.aws.elasticloadbalancingv2.model.TargetHealthDescription.ReadOnly {
    override val target: Option[
      zio.aws.elasticloadbalancingv2.model.TargetDescription.ReadOnly
    ] = scala
      .Option(impl.target())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.TargetDescription.wrap(value)
      )
    override val healthCheckPort: Option[HealthCheckPort] = scala
      .Option(impl.healthCheckPort())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.HealthCheckPort(value)
      )
    override val targetHealth
        : Option[zio.aws.elasticloadbalancingv2.model.TargetHealth.ReadOnly] =
      scala
        .Option(impl.targetHealth())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.TargetHealth.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthDescription
  ): zio.aws.elasticloadbalancingv2.model.TargetHealthDescription.ReadOnly =
    new Wrapper(impl)
}
