package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTargetHealthResponse(
    targetHealthDescriptions: Option[
      Iterable[zio.aws.elasticloadbalancingv2.model.TargetHealthDescription]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse = {
    import DescribeTargetHealthResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse
      .builder()
      .optionallyWith(
        targetHealthDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetHealthDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthResponse
      .wrap(buildAwsValue())
}
object DescribeTargetHealthResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthResponse =
      zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthResponse(
        targetHealthDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def targetHealthDescriptions: Option[List[
      zio.aws.elasticloadbalancingv2.model.TargetHealthDescription.ReadOnly
    ]]
    def getTargetHealthDescriptions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.TargetHealthDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "targetHealthDescriptions",
      targetHealthDescriptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthResponse.ReadOnly {
    override val targetHealthDescriptions: Option[List[
      zio.aws.elasticloadbalancingv2.model.TargetHealthDescription.ReadOnly
    ]] = scala
      .Option(impl.targetHealthDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.TargetHealthDescription
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse
  ): zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthResponse.ReadOnly =
    new Wrapper(impl)
}
